-- Deploy create-oauth-applications

BEGIN;

CREATE TABLE "oauth"."applications" (
  "id" SERIAL PRIMARY KEY,
  "user-id" INTEGER REFERENCES "users"("id") ON DELETE CASCADE,
  "name" CITEXT UNIQUE NOT NULL,
  "description" CITEXT NOT NULL,
  "client-id" UUID UNIQUE NOT NULL,
  "client-secret" TEXT NOT NULL DEFAULT gen_salt('bf'),
  "redirect-uri" TEXT NOT NULL,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX "oauth-applications-client-id-index" ON "oauth"."applications" ("client-id");
CREATE INDEX "oauth-applications-user-id-index" ON "oauth"."applications" ("user-id");

CREATE TRIGGER "oauth-applications-created-at-trigger"
  BEFORE INSERT ON "oauth"."applications" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "oauth-applications-updated-at-trigger"
  BEFORE UPDATE ON "oauth"."applications" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
