-- Deploy update-country-port-count

BEGIN;

CREATE OR REPLACE FUNCTION "update-country-port-count"() RETURNS int AS $$
DECLARE
  row_count int := 0;
BEGIN
  UPDATE countries
     SET "port-count" = u.count
    FROM (SELECT countries.id, count(ports.id)
            FROM countries
       LEFT JOIN ports
              ON ports."country-id" = countries.id
        GROUP BY countries.id) AS u
   WHERE countries.id = u.id;
  GET DIAGNOSTICS row_count = ROW_COUNT;
  RETURN row_count;
END;
$$ LANGUAGE plpgsql;

COMMIT;
