-- Deploy update-region-port-count

BEGIN;

CREATE OR REPLACE FUNCTION "update-region-port-count"() RETURNS int AS $$
DECLARE
  row_count int := 0;
BEGIN
  UPDATE regions
     SET "port-count" = u.count
    FROM (SELECT regions.id, count(ports.id)
            FROM regions
       LEFT JOIN ports
              ON ports."region-id" = regions.id
        GROUP BY regions.id) AS u
   WHERE regions.id = u.id;
  GET DIAGNOSTICS row_count = ROW_COUNT;
  RETURN row_count;
END;
$$ LANGUAGE plpgsql;

COMMIT;
