-- Deploy photo-likes

BEGIN;

ALTER TABLE "photos" ADD COLUMN "likes" INTEGER DEFAULT 0;
ALTER TABLE "photos" ADD COLUMN "dislikes" INTEGER DEFAULT 0;

CREATE TABLE "photo-likes" (
  "photo-id" INTEGER NOT NULL REFERENCES "photos"("id") ON DELETE CASCADE,
  "user-id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "like" BOOLEAN NOT NULL,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE UNIQUE INDEX "photo-likes-photo-id-user-id-idx" ON "photo-likes" ("photo-id", "user-id");

CREATE TRIGGER "photo-likes-created-at-trigger"
  BEFORE INSERT ON "photo-likes" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "photo-likes-updated-at-trigger"
  BEFORE UPDATE ON "photo-likes" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
