(ns burningswell.db.emails
  (:require [clojure.spec.alpha :as s]
            [datumbazo.core :as sql]
            [datumbazo.io :refer [citext]]
            [datumbazo.table :as t]))

(t/deftable emails
  "The emails table."
  (t/column :address :citext)
  (t/column :created-at :timestamp :not-null? true)
  (t/column :id :integer :primary-key? true)
  (t/column :updated-at :timestamp :not-null? true)
  (t/column :user-id :integer :references :users/id)
  (t/column :verified-at :timestamp))

(defn available?
  "Returns true if `email` is available, otherwise false."
  [db email]
  (-> @(sql/select db [1]
         (sql/from :emails)
         (sql/where `(= :address (citext ~email))))
      (empty?)))

(s/fdef available?
  :args (s/cat :db sql/db? :email (s/nilable string?))
  :ret boolean?)
