(ns burningswell.db.connection
  (:require [clojure.spec.test.alpha :as stest]
            [datumbazo.core :as d]))

(defn new-db [config & [opts]]
  (d/new-db config (merge opts {:backend 'jdbc.core})))

(defmacro with-db
  "Eval `body` within the context of a database."
  [[db-sym config] & body]
  `(d/with-db [~db-sym ~config {:backend 'jdbc.core}]
     ~@body))

(defmacro with-test-db
  "Eval `body` within the context of a database."
  [[db-sym config] & body]
  `(d/with-db [~db-sym ~config {:backend 'jdbc.core}]
     (stest/unstrument)
     (stest/instrument)
     ~@body))
