-- Deploy country-count-trigger

BEGIN;

CREATE OR REPLACE FUNCTION "update-country-counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update-continent-country-count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update-country-counts-on-delete-trigger"
  AFTER DELETE ON "countries"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-country-counts"();

CREATE TRIGGER "update-country-counts-on-insert-trigger"
  AFTER INSERT ON "countries"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-country-counts"();

CREATE TRIGGER "update-country-counts-on-update-trigger"
  AFTER UPDATE ON "countries"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-country-counts"();

COMMIT;
