-- Deploy burningswell-db:weather-regions-view to pg

BEGIN;

CREATE MATERIALIZED VIEW weather.regions AS
  SELECT row_number() OVER (ORDER BY "region-id", "variable-id", "valid-time") AS id,
         "region-id", "variable-id", "valid-time", max("reference-time") AS "reference-time", avg(value) AS value, min(value), max(value)
    FROM weather.spots AS w
    JOIN spots
      ON spots.id = w."spot-id"
   WHERE "region-id" IS NOT NULL
  GROUP BY "region-id", "variable-id", "valid-time"
  ORDER BY "region-id", "variable-id", "valid-time";

CREATE INDEX ON weather.regions (id);
CREATE INDEX ON weather.regions ("region-id");
CREATE INDEX ON weather.regions ("valid-time");

REFRESH MATERIALIZED VIEW weather.regions;

COMMIT;
