-- Deploy burningswell-db:add-photo-likes-table to pg

BEGIN;

CREATE TABLE likes.photos (
  "id" SERIAL PRIMARY KEY,
  "photo-id" INTEGER NOT NULL REFERENCES "photos"("id") ON DELETE CASCADE,
  "user-id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE UNIQUE INDEX "likes-photos-photo-id-user-id-idx" ON likes.photos ("photo-id", "user-id");

CREATE TRIGGER "likes-photos-created-at-trigger"
  BEFORE INSERT ON likes.photos FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "likes-photos-updated-at-trigger"
  BEFORE UPDATE ON likes.photos FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
