-- Deploy create-continents-table

BEGIN;

CREATE TABLE "continents" (
  "id" SERIAL PRIMARY KEY,
  "name" CITEXT UNIQUE NOT NULL,
  "code" CITEXT UNIQUE NOT NULL,
  "geom" GEOMETRY(MULTIPOLYGON, 4326),
  "airport-count" INTEGER NOT NULL DEFAULT 0,
  "country-count" INTEGER NOT NULL DEFAULT 0,
  "port-count" INTEGER NOT NULL DEFAULT 0,
  "region-count" INTEGER NOT NULL DEFAULT 0,
  "spot-count" INTEGER NOT NULL DEFAULT 0,
  "user-count" INTEGER NOT NULL DEFAULT 0,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "continents-name-fulltext-index" ON "continents" USING gin(to_tsvector('english', "name"));
CREATE INDEX "continents-geom-index" ON "continents" USING gist("geom");

CREATE TRIGGER "continents-created-at-trigger"
  BEFORE INSERT ON "continents" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "continents-updated-at-trigger"
  BEFORE UPDATE ON "continents" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
