(ns burningswell.db.signin
  (:require [datumbazo.core :as sql]))

(defn- credentials-clause
  "Returns the SQL clause to select a user by `credentials`."
  [{:keys [login password] :as credentials}]
  `(and (or (= :username ~login) (= :address ~login))
        (= :crypted-password (crypt ~password :crypted-password))))

(defn by-credentials
  "Returns the user by `credentials` from `db`."
  [db {:keys [login password] :as credentials}]
  (first @(sql/select db [:users.id]
            (sql/from :users)
            (sql/join :emails.user-id :users.id)
            (sql/where (credentials-clause credentials)))))
