-- Deploy create-countries-table

BEGIN;

CREATE TABLE countries (
  "id" SERIAL PRIMARY KEY,
  "continent-id" INTEGER NOT NULL REFERENCES continents(id) ON DELETE CASCADE,
  "name" CITEXT UNIQUE NOT NULL,
  "iso-3166-1-alpha-2" CITEXT UNIQUE NOT NULL,
  "iso-3166-1-alpha-3" CITEXT UNIQUE NOT NULL,
  "iso-3166-1-numeric" INTEGER UNIQUE NOT NULL,
  "fips-code" CITEXT UNIQUE NOT NULL,
  "geonames-id" INTEGER UNIQUE,
  "phone-prefix" CITEXT UNIQUE NOT NULL,
  "area" INTEGER NOT NULL,
  "population" INTEGER NOT NULL,
  "geom" GEOMETRY(MULTIPOLYGON, 4326),
  "airport-count" INTEGER NOT NULL DEFAULT 0,
  "port-count" INTEGER NOT NULL DEFAULT 0,
  "region-count" INTEGER NOT NULL DEFAULT 0,
  "spot-count" INTEGER NOT NULL DEFAULT 0,
  "user-count" INTEGER NOT NULL DEFAULT 0,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "countries-name-fulltext-index" ON "countries" USING gin(to_tsvector('english', "name"));
CREATE INDEX "countries-geom-index" ON countries USING gist("geom");

CREATE TRIGGER "countries-created-at-trigger"
  BEFORE INSERT ON "countries" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "countries-updated-at-trigger"
  BEFORE UPDATE ON "countries" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
