-- Deploy create-weather-spot-forecasts-view

BEGIN;

CREATE MATERIALIZED VIEW weather."spot-forecasts" AS
  SELECT *
    FROM weather."spots"
   WHERE "valid-time" >= date_trunc('day', clock_timestamp())
   ORDER BY "spot-id", "valid-time";

CREATE INDEX "weather-spot-forecasts-spot-id-valid-time" ON weather."spot-forecasts" ("spot-id", "valid-time");
CREATE UNIQUE INDEX "weather-spot-forecasts-spot-id-variable-id-valid-time" ON weather."spot-forecasts" ("spot-id", "variable-id", "valid-time");

COMMIT;
