-- Deploy burningswell-db:linkedin-schema to pg

BEGIN;

CREATE SCHEMA linkedin;

CREATE TABLE linkedin.users (
  "id" TEXT PRIMARY KEY,
  "user-id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "profile" JSONB,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL,
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL
);

CREATE INDEX "linkedin-users-user-id-idx" ON linkedin.users ("user-id");

CREATE TRIGGER "linkedin-users-before-insert-created-at"
  BEFORE INSERT ON linkedin.users FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "linkedin-users-before-insert-updated-at"
  BEFORE INSERT ON linkedin.users FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

CREATE TRIGGER "linkedin-users-before-update-updated-at"
  BEFORE UPDATE ON linkedin.users FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
