-- Deploy burningswell-db:weather-continents-view to pg

BEGIN;

CREATE MATERIALIZED VIEW weather.continents AS
  SELECT row_number() OVER (ORDER BY "continent-id", "variable-id", "valid-time") AS id,
         "continent-id", "variable-id", "valid-time", max("reference-time") AS "reference-time", avg(value) AS value, min(value), max(value)
    FROM weather.spots AS w
    JOIN spots
      ON spots.id = w."spot-id"
    JOIN countries
      ON countries.id = spots."country-id"
   WHERE "continent-id" IS NOT NULL
  GROUP BY "continent-id", "variable-id", "valid-time"
  ORDER BY "continent-id", "variable-id", "valid-time";

CREATE INDEX ON weather.continents (id);
CREATE INDEX ON weather.continents ("continent-id");
CREATE INDEX ON weather.continents ("valid-time");

REFRESH MATERIALIZED VIEW weather.continents;

COMMIT;
