-- Deploy burningswell-db:emails to pg

BEGIN;

CREATE TABLE emails (
  "id" SERIAL PRIMARY KEY,
  "user-id" INTEGER REFERENCES users(id) ON DELETE CASCADE,
  "address" CITEXT NOT NULL UNIQUE,
  "verified-at" TIMESTAMP WITH TIME ZONE,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL,
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL
);

CREATE INDEX "emails-user-id" ON emails("user-id");

ALTER TABLE users ADD COLUMN "email-id" INTEGER UNIQUE REFERENCES emails(id);
CREATE INDEX "users-email-id" ON users("email-id");

CREATE TRIGGER "emails-before-insert-created-at"
  BEFORE INSERT ON emails FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "emails-before-insert-updated-at"
  BEFORE INSERT ON emails FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

CREATE TRIGGER "emails-before-update-updated-at"
  BEFORE UPDATE ON emails FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

INSERT INTO emails ("user-id", address, "verified-at") SELECT id, email, "created-at" FROM users;

UPDATE users
   SET "email-id" = u.id
  FROM (SELECT id, "user-id" FROM emails) AS u
 WHERE users.id = u."user-id";

ALTER TABLE users DROP COLUMN "email";

COMMIT;
