-- Deploy airport_count_trigger

BEGIN;

CREATE OR REPLACE FUNCTION "update_airport_counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update_continent_airport_count"();
  PERFORM "update_country_airport_count"();
  PERFORM "update_region_airport_count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update_airport_counts_on_delete_trigger"
  AFTER DELETE ON "airports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_airport_counts"();

CREATE TRIGGER "update_airport_counts_on_insert_trigger"
  AFTER INSERT ON "airports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_airport_counts"();

CREATE TRIGGER "update_airport_counts_on_update_trigger"
  AFTER UPDATE ON "airports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_airport_counts"();

COMMIT;
