-- Deploy create_daily_spot_forecasts_view

BEGIN;

CREATE OR REPLACE VIEW "weather"."daily_spot_forecasts" AS
    SELECT "spot_id", "model_id", "variable_id",
           avg("value") AS "value",
           max("reference_time") AS "reference_time",
           date("valid_time") AS "valid_time",
           min("created_at") AS "created_at",
           max("updated_at") AS "updated_at"
      FROM "weather"."spot_forecasts"
  GROUP BY "spot_id", "model_id", "variable_id", date("valid_time")
  ORDER BY "spot_id", date("valid_time");

COMMIT;
