-- Deploy create_roles_users_table

BEGIN;

CREATE TABLE "roles_users" (
  "role_id" INTEGER NOT NULL REFERENCES "roles"("id") ON DELETE CASCADE,
  "user_id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE UNIQUE INDEX "roles_users_role_id_user_id_index" ON "roles_users"("role_id", "user_id");

CREATE TRIGGER "roles_users_created_at_trigger"
  BEFORE INSERT ON "roles_users" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "roles_users_updated_at_trigger"
  BEFORE UPDATE ON "roles_users" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
