-- Deploy create_spot_weather_3_hours_view

BEGIN;

CREATE MATERIALIZED VIEW "weather"."spot_weather_3_hours" AS
  SELECT "spot_id", "model_id", "variable_id",
         avg("value") AS "value",
         max("unit") AS "unit",
         max("valid_time") as "valid_time"
    FROM "weather"."spot_forecasts" AS "forecasts"
    JOIN "weather"."models"
      ON "weather"."models"."id" = "forecasts"."model_id"
    JOIN "weather"."variables"
      ON "weather"."variables"."id" = "forecasts"."variable_id"
GROUP BY "spot_id", "model_id", "variable_id",
         extract(year FROM "valid_time"),
         extract(month FROM "valid_time"),
         extract(day FROM "valid_time"),
         extract(hour FROM "valid_time") / 3;

COMMIT;
