-- Deploy create_svm_features_view

BEGIN;

CREATE VIEW "weather"."svm_features" AS
  SELECT "spot_id",
         "spot_name",
         "valid_time",
         "rating",
	 "dirpwsfc",
	 "dirswsfc",
	 "htsgwsfc",
	 "perpwsfc",
	 "perswsfc",
	 "tcdcclm",
	 "tmpsfc",
	 "ugrdsfc",
	 "vgrdsfc",
	 "wdirsfc",
	 "windsfc",
	 "wvdirsfc",
	 "wvpersfc"
    FROM crosstab('SELECT CAST("spots"."name" AS TEXT) || CAST("valid_time" AS TEXT),
			  "spots"."id",
			  "spots"."name",
                          "valid_time",
                          "rating",
			  "variables"."name",
			  "value"
		     FROM "weather"."spot_forecasts"
		     JOIN "weather"."models"
		       ON "models"."id" = "model_id"
		     JOIN "weather"."variables"
		       ON "variables"."id" = "variable_id"
		     JOIN "spots"
		       ON "spots"."id" = "spot_id"
		     JOIN "ratings"
		       ON "ratings"."spot_id" = "spots"."id"
		      AND extract(year from "ratings"."created_at") = extract(year from "spot_forecasts"."valid_time")
		      AND extract(month from "ratings"."created_at") = extract(month from "spot_forecasts"."valid_time")
		      AND extract(day from "ratings"."created_at") = extract(day from "spot_forecasts"."valid_time")
		      AND extract(hour from "ratings"."created_at")::int % 3 = extract(hour from "spot_forecasts"."valid_time")::int % 3
		 ORDER BY 1',
		  'SELECT DISTINCT("name") FROM "weather"."variables" ORDER BY "name"')
      AS ("row_name" TEXT,
          "spot_id" INTEGER,
	  "spot_name" TEXT,
          "valid_time" TIMESTAMP WITH TIME ZONE,
          "rating" INTEGER,
	  "dirpwsfc" FLOAT,
	  "dirswsfc" FLOAT,
	  "htsgwsfc" FLOAT,
	  "perpwsfc" FLOAT,
	  "perswsfc" FLOAT,
	  "tcdcclm" FLOAT,
	  "tmpsfc" FLOAT,
	  "ugrdsfc" FLOAT,
	  "vgrdsfc" FLOAT,
	  "wdirsfc" FLOAT,
	  "windsfc" FLOAT,
	  "wvdirsfc" FLOAT,
	  "wvpersfc" FLOAT);

COMMIT;
