-- Deploy create_weather_models_table

BEGIN;

CREATE TABLE "weather"."models" (
  "id" SERIAL PRIMARY KEY,
  "name" CITEXT NOT NULL,
  "description" TEXT NOT NULL,
  "dods" TEXT NOT NULL,
  "res_x" FLOAT NOT NULL,
  "res_y" FLOAT NOT NULL,
  "latest_reference_time" TIMESTAMP WITH TIME ZONE,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "weather_models_name_fulltext_index" ON "weather"."models" USING gin(to_tsvector('english', "name"));

CREATE TRIGGER "weather_models_created_at_trigger"
  BEFORE INSERT ON "weather"."models" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "weather_models_updated_at_trigger"
  BEFORE UPDATE ON "weather"."models" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
