-- Deploy burningswell_db:emails to pg

BEGIN;

CREATE TABLE emails (
  "id" SERIAL PRIMARY KEY,
  "user_id" INTEGER REFERENCES users(id) ON DELETE CASCADE,
  "address" CITEXT NOT NULL UNIQUE,
  "verified_at" TIMESTAMP WITH TIME ZONE,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL,
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL
);

CREATE INDEX "emails_user_id" ON emails("user_id");

ALTER TABLE users ADD COLUMN "email_id" INTEGER UNIQUE REFERENCES emails(id);
CREATE INDEX "users_email_id" ON users("email_id");

CREATE TRIGGER "emails_before_insert_created_at"
  BEFORE INSERT ON emails FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "emails_before_insert_updated_at"
  BEFORE INSERT ON emails FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

CREATE TRIGGER "emails_before_update_updated_at"
  BEFORE UPDATE ON emails FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

INSERT INTO emails ("user_id", address, "verified_at") SELECT id, email, "created_at" FROM users;

UPDATE users
   SET "email_id" = u.id
  FROM (SELECT id, "user_id" FROM emails) AS u
 WHERE users.id = u."user_id";

ALTER TABLE users DROP COLUMN "email";

COMMIT;
