-- Deploy update_continent_airport_count

BEGIN;

CREATE OR REPLACE FUNCTION "update_continent_airport_count"() RETURNS int AS $$
DECLARE
  row_count int := 0;
BEGIN
  UPDATE continents
     SET "airport_count" = u.count
    FROM (SELECT continents.id, count(airports.id)
            FROM continents
       LEFT JOIN countries
              ON countries."continent_id" = continents.id
       LEFT JOIN airports
              ON airports."country_id" = countries.id
        GROUP BY continents.id) AS u
   WHERE continents.id = u.id;
  GET DIAGNOSTICS row_count = ROW_COUNT;
  RETURN row_count;
END;
$$ LANGUAGE plpgsql;

COMMIT;
