-- Deploy create_oauth_access_tokens

BEGIN;

CREATE TABLE "oauth"."access_tokens" (
  "id" SERIAL PRIMARY KEY,
  "application_id" INTEGER NOT NULL REFERENCES "oauth"."applications"("id") ON DELETE CASCADE,
  "user_id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "access_token" TEXT UNIQUE NOT NULL,
  "refresh_token" TEXT UNIQUE NOT NULL,
  "expires_at" TIMESTAMP WITH TIME ZONE,
  "revoked_at" TIMESTAMP WITH TIME ZONE,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "oauth_access_tokens_application_id_index" ON "oauth"."access_tokens" ("application_id");
CREATE INDEX "oauth_access_tokens_user_id_index" ON "oauth"."access_tokens" ("user_id");

CREATE TRIGGER "oauth_access_tokens_created_at_trigger"
  BEFORE INSERT ON "oauth"."access_tokens" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "oauth_access_tokens_updated_at_trigger"
  BEFORE UPDATE ON "oauth"."access_tokens" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
