-- Deploy create_photo_label_scores_table

BEGIN;

CREATE TABLE "photo_label_scores" (
  "id" SERIAL PRIMARY KEY,
  "photo_id" INTEGER NOT NULL REFERENCES "photos" (id) ON DELETE CASCADE,
  "photo_label_id" INTEGER NOT NULL REFERENCES "photo_labels" (id) ON DELETE CASCADE,
  "score" DOUBLE PRECISION NOT NULL CHECK ("score" >= 0.0 AND "score" <= 1.0),
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE UNIQUE INDEX "photo_label_scores_unique_index" ON "photo_label_scores" ("photo_label_id", "photo_id");

CREATE TRIGGER "photo_label_scores_created_at_trigger"
  BEFORE INSERT ON "photo_label_scores" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "photo_label_scores_updated_at_trigger"
  BEFORE UPDATE ON "photo_label_scores" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
