-- Deploy create_spots_table

BEGIN;

CREATE TABLE "spots" (
  "id" SERIAL PRIMARY KEY,
  "country_id" INTEGER NOT NULL REFERENCES "countries"("id") ON DELETE CASCADE,
  "region_id" INTEGER REFERENCES "regions"("id") ON DELETE CASCADE,
  "user_id" INTEGER REFERENCES "users"("id") ON DELETE SET NULL,
  "name" CITEXT NOT NULL,
  "location" GEOMETRY(POINT, 4326),
  "visible" TEXT NOT NULL DEFAULT 'public',
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "spots_name_fulltext_index" ON "spots" USING gin(to_tsvector('english', "name"));
CREATE INDEX "spots_location_index" ON "spots" USING gist("location");
CREATE INDEX "spots_visible_index" ON "spots" ("visible");

CREATE TRIGGER "spots_created_at_trigger"
  BEFORE INSERT ON "spots" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "spots_updated_at_trigger"
  BEFORE UPDATE ON "spots" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
