-- Deploy create_users_table

BEGIN;

CREATE TABLE "users" (
  "id" SERIAL PRIMARY KEY,
  "country_id" INTEGER REFERENCES "countries"("id") ON DELETE CASCADE,
  "region_id" INTEGER REFERENCES "regions"("id") ON DELETE CASCADE,
  "username" CITEXT NOT NULL UNIQUE,
  "email" CITEXT UNIQUE,
  "name" TEXT,
  "first_name" TEXT,
  "last_name" TEXT,
  "crypted_password" TEXT,
  "location" GEOMETRY(POINT, 4326),
  "locale" TEXT,
  "facebook_id" TEXT UNIQUE,
  "facebook_url" TEXT UNIQUE,
  "google_id" TEXT UNIQUE,
  "google_url" TEXT,
  "twitter_id" TEXT UNIQUE,
  "twitter_url" TEXT,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "users_username_fulltext_index" ON "users" USING gin(to_tsvector('english', "username"));

CREATE TRIGGER "users_created_at_trigger"
  BEFORE INSERT ON "users" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "users_updated_at_trigger"
  BEFORE UPDATE ON "users" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
