-- Deploy burningswell_db:weather_continents_view to pg

BEGIN;

CREATE MATERIALIZED VIEW weather.continents AS
  SELECT row_number() OVER (ORDER BY "continent_id", "variable_id", "valid_time") AS id,
         "continent_id", "variable_id", "valid_time", max("reference_time") AS "reference_time", avg(value) AS value, min(value), max(value)
    FROM weather.spots AS w
    JOIN spots
      ON spots.id = w."spot_id"
    JOIN countries
      ON countries.id = spots."country_id"
   WHERE "continent_id" IS NOT NULL
  GROUP BY "continent_id", "variable_id", "valid_time"
  ORDER BY "continent_id", "variable_id", "valid_time";

CREATE INDEX ON weather.continents (id);
CREATE INDEX ON weather.continents ("continent_id");
CREATE INDEX ON weather.continents ("valid_time");

REFRESH MATERIALIZED VIEW weather.continents;

COMMIT;
