-- Deploy create_weather_forecasts_table

BEGIN;

CREATE TABLE "weather"."forecasts" (
  "id" SERIAL PRIMARY KEY,
  "spot_id" INTEGER NOT NULL REFERENCES "spots"("id") ON DELETE CASCADE,
  "model_id" INTEGER NOT NULL REFERENCES "weather"."models"("id") ON DELETE CASCADE,
  "variable_id" INTEGER NOT NULL REFERENCES "weather"."variables"("id") ON DELETE CASCADE,
  "reference_time" TIMESTAMP WITH TIME ZONE NOT NULL,
  "valid_time" TIMESTAMP WITH TIME ZONE NOT NULL,
  "value" FLOAT,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE UNIQUE INDEX "weather_forecasts_spot_id_variable_id_valid_time_index" ON "weather"."forecasts" ("spot_id", "variable_id", "valid_time");
CREATE INDEX "weather_forecasts_spot_id_valid_time_index" ON "weather"."forecasts" ("spot_id", "valid_time");

CREATE TRIGGER "weather_forecasts_created_at_trigger"
  BEFORE INSERT ON "weather"."forecasts" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "weather_forecasts_updated_at_trigger"
  BEFORE UPDATE ON "weather"."forecasts" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
