-- Deploy burningswell_db:update_photos_dislikes_trigger to pg

BEGIN;

CREATE TRIGGER "update_photo_dislikes"
  AFTER INSERT OR UPDATE OR DELETE ON "dislikes"."photos"
  FOR EACH ROW EXECUTE PROCEDURE "counter_cache"('photos', 'dislikes', 'photo_id');

CREATE TRIGGER "update_photo_dislikes_truncate"
  AFTER TRUNCATE ON "dislikes"."photos"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "counter_cache"('photos', 'dislikes', 'photo_id');

COMMIT;
