-- Deploy recreate_images

BEGIN;

ALTER TABLE "photos" DROP COLUMN "flickr_url";
ALTER TABLE "photos" DROP COLUMN "content_length";
ALTER TABLE "photos" DROP COLUMN "content_md5";
ALTER TABLE "photos" DROP COLUMN "content_type";
ALTER TABLE "photos" DROP COLUMN "s3_key";
ALTER TABLE "photos" DROP COLUMN "width";
ALTER TABLE "photos" DROP COLUMN "height";
ALTER TABLE "photos" RENAME COLUMN "original_url" TO "url";

CREATE TABLE "images" (
  "id" SERIAL PRIMARY KEY,
  "photo_id" INTEGER NOT NULL REFERENCES photos(id) ON DELETE CASCADE,
  "content_disposition" TEXT NOT NULL,
  "content_length" INTEGER NOT NULL CHECK ("content_length" >= 0),
  "content_md5" TEXT NOT NULL,
  "content_type" TEXT NOT NULL,
  "width" INTEGER NOT NULL CHECK ("width" >= 0),
  "height" INTEGER NOT NULL CHECK ("height" >= 0),
  "label" TEXT NOT NULL,
  "s3_key" TEXT NOT NULL UNIQUE,
  "url" TEXT NOT NULL UNIQUE,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "images_photo_id_index" ON "images" ("photo_id");
CREATE UNIQUE INDEX "images_photo_id_label_index" ON "images" ("photo_id", "label");
CREATE UNIQUE INDEX "images_url_index" ON "images" ("url");
CREATE UNIQUE INDEX "images_s3_key_index" ON "images" ("s3_key");
CREATE INDEX "images_width_index" ON "images" ("width");
CREATE INDEX "images_width_height_index" ON "images" ("width", "height");
CREATE INDEX "images_height_index" ON "images" ("height");

CREATE TRIGGER "images_created_at_trigger"
  BEFORE INSERT ON images FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "images_updated_at_trigger"
  BEFORE UPDATE ON images FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
