-- Deploy burningswell_db:add_photo_likes_table to pg

BEGIN;

CREATE TABLE likes.photos (
  "id" SERIAL PRIMARY KEY,
  "photo_id" INTEGER NOT NULL REFERENCES "photos"("id") ON DELETE CASCADE,
  "user_id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE UNIQUE INDEX "likes_photos_photo_id_user_id_idx" ON likes.photos ("photo_id", "user_id");

CREATE TRIGGER "likes_photos_created_at_trigger"
  BEFORE INSERT ON likes.photos FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "likes_photos_updated_at_trigger"
  BEFORE UPDATE ON likes.photos FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
