-- Deploy burningswell-db:gravatar-users to pg

BEGIN;

CREATE TABLE gravatar.users (
  id TEXT PRIMARY KEY,
  display_name TEXT,
  hash TEXT NOT NULL UNIQUE,
  preferred_username TEXT,
  profile_url TEXT NOT NULL UNIQUE,
  request_hash TEXT NOT NULL UNIQUE,
  thumbnail_url TEXT NOT NULL UNIQUE,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL,
  updated_at TIMESTAMP WITH TIME ZONE NOT NULL
);

CREATE INDEX gravatar_users_hash ON gravatar.users(hash);

CREATE TRIGGER gravatar_users_before_insert_created_at
  BEFORE INSERT ON gravatar.users FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER gravatar_users_before_insert_updated_at
  BEFORE INSERT ON gravatar.users FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

CREATE TRIGGER gravatar_users_before_update_updated_at
  BEFORE UPDATE ON gravatar.users FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
