-- Deploy update_country_airport_count

BEGIN;

CREATE OR REPLACE FUNCTION "update_country_airport_count"() RETURNS int AS $$
DECLARE
  row_count int := 0;
BEGIN
  UPDATE countries
     SET "airport_count" = u.count
    FROM (SELECT countries.id, count(airports.id)
            FROM countries
       LEFT JOIN airports
              ON airports."country_id" = countries.id
        GROUP BY countries.id) AS u
   WHERE countries.id = u.id;
  GET DIAGNOSTICS row_count = ROW_COUNT;
  RETURN row_count;
END;
$$ LANGUAGE plpgsql;

COMMIT;
