(ns burningswell.db.ports
  (:require [datumbazo.table :as t]))

(t/deftable ports
  "The ports table."
  (t/column :country-id :integer :not-null? true)
  (t/column :created-at :timestamp :not-null? true)
  (t/column :id :integer :primary-key? true :not-null? true)
  (t/column :location :geography :not-null? true)
  (t/column :name :citext :not-null? true)
  (t/column :region-id :integer)
  (t/column :type :citext :not-null? true)
  (t/column :updated-at :timestamp :not-null? true)
  (t/column :website-url :text))

(defn honolulu
  "Returns the Honolulu port."
  [db]
  (by-id db 238))

;; (defn- select-all
;;   "Returns all ports."
;;   [db & [opts]]
;;   (let [{:keys [query page per-page]} opts]
;;     (select db [:ports.id
;;                 :ports.name
;;                 (as '(cast :ports.location :geometry) :location)
;;                 :ports.type
;;                 :ports.website-url
;;                 :ports.created-at
;;                 :ports.updated-at
;;                 (as `(json_build_object
;;                       "country" (json-embed-country :countries)
;;                       "region" (json-embed-region :regions))
;;                     :_embedded)]
;;       (from :ports)
;;       (join :countries.id :ports.country-id)
;;       (join :regions.id :ports.region-id :type :left)
;;       (fulltext query :ports.name)
;;       (if-let [location (:location opts)]
;;         (order-by-distance :ports.location location)
;;         (order-by :ports.name))
;;       (paginate page per-page))))

;; (s/defn all :- [Port]
;;   "Return all ports in `db`."
;;   [db :- Database & [opts]]
;;   @(select-all db opts))

;; (s/defn by-id :- (s/maybe Port)
;;   "Return the country in `db` by `id`."
;;   [db :- Database id :- s/Num]
;;   (first @(compose
;;            (select-all db)
;;            (where `(= :ports.id (cast ~id :integer))))))

;; (s/defn by-name :- (s/maybe Port)
;;   "Return the country in `db` by `name`."
;;   [db :- Database name :- s/Str]
;;   (first @(compose
;;            (select-all db)
;;            (where `(= :ports.name ~name)))))

;; (defn- row [continent]
;;   (assoc (select-keys continent [:name :location :type :website-url])
;;          :country-id (-> continent :_embedded :country :id)
;;          :region-id (-> continent :_embedded :region :id)))

;; (s/defn delete
;;   "Delete `port` from `db`."
;;   [db :- Database port :- Port]
;;   (->> @(sql/delete db :ports
;;           (where `(= :ports.id
;;                      ~(:id port))))
;;        first :count))

;; (s/defn in-continent :- [Port]
;;   "Returns all ports in `continent`."
;;   [db :- Database continent :- Continent & [opts]]
;;   @(compose
;;     (select-all db opts)
;;     (where `(= :countries.continent-id ~(:id continent)))))

;; (s/defn in-country :- [Port]
;;   "Returns all ports in `country`."
;;   [db :- Database country :- Country & [opts]]
;;   @(compose
;;     (select-all db opts)
;;     (where `(= :ports.country-id ~(:id country)))))

;; (s/defn in-region :- [Port]
;;   "Returns all ports in `region`."
;;   [db :- Database region :- Region & [opts]]
;;   @(compose
;;     (select-all db opts)
;;     (where `(= :ports.region-id ~(:id region)))))

;; (s/defn insert
;;   "Insert `port` into `db`."
;;   [db :- Database port]
;;   (->> @(sql/insert db :ports []
;;           (values [(row port)])
;;           (returning :id))
;;        first :id (by-id db)))

;; (s/defn update
;;   "Update `port` in `db`."
;;   [db :- Database port]
;;   (->> @(sql/update db :ports
;;           (row port)
;;           (where `(= :ports.id
;;                      ~(:id port)))
;;           (returning :id))
;;        first :id (by-id db)))
