-- Deploy upsert_photo_like

BEGIN;

CREATE OR REPLACE FUNCTION "upsert_photo_like"("photo_id" integer, "user_id" integer, "like" boolean)
RETURNS void AS $$
#variable_conflict use_variable
BEGIN
  WITH upsert AS (UPDATE "photo_likes"
                     SET "like" = "like"
                   WHERE "photo_likes"."photo_id" = "photo_id"
                     AND "photo_likes"."user_id" = "user_id"
               RETURNING *)
    INSERT INTO "photo_likes" ("photo_id", "user_id", "like")
      SELECT "photo_id", "user_id", "like"
       WHERE NOT EXISTS (SELECT * FROM upsert);
END;
$$ LANGUAGE plpgsql;

COMMIT;
