-- Deploy burningswell_db:add_photo_dislikes_table to pg

BEGIN;

CREATE TABLE dislikes.photos (
  "id" SERIAL PRIMARY KEY,
  "photo_id" INTEGER NOT NULL REFERENCES "photos"("id") ON DELETE CASCADE,
  "user_id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE UNIQUE INDEX "dislikes_photos_photo_id_user_id_idx" ON dislikes.photos ("photo_id", "user_id");

CREATE TRIGGER "dislikes_photos_created_at_trigger"
  BEFORE INSERT ON dislikes.photos FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "dislikes_photos_updated_at_trigger"
  BEFORE UPDATE ON dislikes.photos FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
