-- Deploy create_photos_table

BEGIN;

CREATE TABLE "photos" (
  "id" SERIAL PRIMARY KEY,
  "spot_id" INTEGER REFERENCES spots(id) ON DELETE CASCADE,
  "user_id" INTEGER REFERENCES users(id) ON DELETE SET NULL,
  "flickr_id" BIGINT UNIQUE,
  "title" TEXT,
  "location" GEOMETRY(POINT, 4326),
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "photos_location_index" ON "photos" USING gist("location");
CREATE INDEX "photos_spot_id_index" ON "photos" ("spot_id");
CREATE INDEX "photos_title_fulltext_index" ON "photos" USING gin(to_tsvector('english', "title"));

CREATE TRIGGER "photos_created_at_trigger"
  BEFORE INSERT ON "photos" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "photos_updated_at_trigger"
  BEFORE UPDATE ON "photos" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
