-- Deploy create_weather_variables_table

BEGIN;

CREATE TABLE "weather"."variables" (
  "id" SERIAL PRIMARY KEY,
  "name" CITEXT NOT NULL,
  "description" TEXT NOT NULL,
  "unit" TEXT NOT NULL,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "weather_variables_name_fulltext_index" ON "weather"."variables" USING gin(to_tsvector('english', "name"));

CREATE TRIGGER "weather_variables_created_at_trigger"
  BEFORE INSERT ON "weather"."variables" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "weather_variables_updated_at_trigger"
  BEFORE UPDATE ON "weather"."variables" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
