-- Revert delete_images

BEGIN;

DROP TABLE "photos_spots";

ALTER TABLE "photos" DROP COLUMN "content_length";
ALTER TABLE "photos" DROP COLUMN "content_md5";
ALTER TABLE "photos" DROP COLUMN "content_type";
ALTER TABLE "photos" DROP COLUMN "flickr_owner_id";
ALTER TABLE "photos" DROP COLUMN "flickr_owner_name";
ALTER TABLE "photos" DROP COLUMN "flickr_owner_url";
ALTER TABLE "photos" DROP COLUMN "flickr_url";
ALTER TABLE "photos" DROP COLUMN "height";
ALTER TABLE "photos" DROP COLUMN "original_url";
ALTER TABLE "photos" DROP COLUMN "s3_key";
ALTER TABLE "photos" DROP COLUMN "status";
ALTER TABLE "photos" DROP COLUMN "width";

ALTER TABLE "photos" ADD COLUMN "spot_id" INTEGER REFERENCES spots(id) ON DELETE CASCADE;
CREATE INDEX "photos_spot_id_index" ON "photos" ("spot_id");

CREATE TABLE "images" (
  "id" SERIAL PRIMARY KEY,
  "photo_id" INTEGER NOT NULL REFERENCES photos(id) ON DELETE CASCADE,
  "width" INTEGER NOT NULL,
  "height" INTEGER NOT NULL,
  "label" TEXT NOT NULL,
  "url" TEXT NOT NULL UNIQUE,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX "images_photo_id_index" ON "images" ("photo_id");
CREATE INDEX "images_photo_id_width_height_index" ON "images" ("photo_id", "width", "height");
CREATE INDEX "images_width_index" ON "images" ("width");
CREATE INDEX "images_width_height_index" ON "images" ("width", "height");
CREATE INDEX "images_height_index" ON "images" ("height");

CREATE TRIGGER "images_created_at_trigger"
  BEFORE INSERT ON images FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "images_updated_at_trigger"
  BEFORE UPDATE ON images FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

CREATE OR REPLACE VIEW "thumbnails" AS
  SELECT DISTINCT ON ("spot_id") "photos".*, "images"."width", "images"."height", "images"."url"
    FROM "images"
    JOIN "photos"
      ON "photos"."id" = "images"."photo_id"
   WHERE "width" >= 200
     AND "height" >= 100
ORDER BY "spot_id", "updated_at";

COMMIT;
