-- Deploy update_photo_likes

BEGIN;

CREATE FUNCTION "update_photo_likes"() RETURNS trigger AS $$
BEGIN
  IF (TG_OP = 'DELETE' AND OLD.like) THEN
    UPDATE "photos" SET "likes" = "likes" - 1 WHERE "id" = OLD."photo_id";
    RETURN OLD;
  ELSIF (TG_OP = 'DELETE' AND NOT OLD.like) THEN
    UPDATE "photos" SET "dislikes" = "dislikes" - 1 WHERE "id" = OLD."photo_id";
    RETURN OLD;
  ELSIF (TG_OP = 'INSERT' AND NEW.like) THEN
    UPDATE "photos" SET "likes" = "likes" + 1 WHERE "id" = NEW."photo_id";
    RETURN NEW;
  ELSIF (TG_OP = 'INSERT' AND NOT NEW.like) THEN
    UPDATE "photos" SET "dislikes" = "dislikes" + 1 WHERE "id" = NEW."photo_id";
    RETURN NEW;
  ELSIF (TG_OP = 'TRUNCATE') THEN
    UPDATE "photos"
       SET "likes" = 0, "dislikes" = 0;
    RETURN NEW;
  ELSIF (TG_OP = 'UPDATE' AND OLD.like = NEW.like) THEN
    RETURN NEW;
  ELSIF (TG_OP = 'UPDATE' AND NEW.like) THEN
    UPDATE "photos"
       SET "likes" = "likes" + 1, "dislikes" = "dislikes" - 1
     WHERE "id" = NEW."photo_id";
    RETURN NEW;
  ELSIF (TG_OP = 'UPDATE' AND NOT NEW.like) THEN
    UPDATE "photos"
       SET "likes" = "likes" - 1, "dislikes" = "dislikes" + 1
     WHERE "id" = NEW."photo_id";
    RETURN NEW;
  END IF;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update_photo_likes_on_delete_trigger"
  AFTER DELETE ON "photo_likes"
  FOR EACH ROW
  EXECUTE PROCEDURE "update_photo_likes"();

CREATE TRIGGER "update_photo_likes_on_insert_trigger"
  AFTER INSERT ON "photo_likes"
  FOR EACH ROW
  EXECUTE PROCEDURE "update_photo_likes"();

CREATE TRIGGER "update_photo_likes_on_truncate_trigger"
  AFTER TRUNCATE ON "photo_likes"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_photo_likes"();

CREATE TRIGGER "update_photo_likes_on_update_trigger"
  AFTER UPDATE ON "photo_likes"
  FOR EACH ROW
  EXECUTE PROCEDURE "update_photo_likes"();

COMMIT;
