-- Deploy burningswell_db:weather_regions_view to pg

BEGIN;

CREATE MATERIALIZED VIEW weather.regions AS
  SELECT row_number() OVER (ORDER BY "region_id", "variable_id", "valid_time") AS id,
         "region_id", "variable_id", "valid_time", max("reference_time") AS "reference_time", avg(value) AS value, min(value), max(value)
    FROM weather.spots AS w
    JOIN spots
      ON spots.id = w."spot_id"
   WHERE "region_id" IS NOT NULL
  GROUP BY "region_id", "variable_id", "valid_time"
  ORDER BY "region_id", "variable_id", "valid_time";

CREATE INDEX ON weather.regions (id);
CREATE INDEX ON weather.regions ("region_id");
CREATE INDEX ON weather.regions ("valid_time");

REFRESH MATERIALIZED VIEW weather.regions;

COMMIT;
