-- Deploy burningswell_db:google_schema to pg

BEGIN;

CREATE SCHEMA google;

CREATE TABLE google.users (
  "id" TEXT PRIMARY KEY,
  "user_id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "profile" JSONB,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL,
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL
);

CREATE INDEX "google_users_user_id_idx" ON google.users ("user_id");

CREATE TRIGGER "google_users_before_insert_created_at"
  BEFORE INSERT ON google.users FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "google_users_before_insert_updated_at"
  BEFORE INSERT ON google.users FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

CREATE TRIGGER "google_users_before_update_updated_at"
  BEFORE UPDATE ON google.users FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
