-- Deploy burningswell-db:flickr-photo-sizes-table to pg

BEGIN;

CREATE TABLE flickr.photo_sizes (
  id SERIAL,
  photo_id TEXT NOT NULL REFERENCES flickr.photos(id) ON DELETE CASCADE,
  width INTEGER NOT NULL,
  height INTEGER NOT NULL,
  label TEXT NOT NULL,
  media TEXT NOT NULL,
  source TEXT NOT NULL,
  url TEXT NOT NULL,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  updated_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  PRIMARY KEY(photo_id, label)
);

CREATE INDEX flickr_photo_sizes_photo_id ON flickr.photo_sizes(photo_id);
CREATE INDEX flickr_photo_sizes_source ON flickr.photo_sizes(source);

CREATE TRIGGER flickr_photo_sizes_created_at_trigger
  BEFORE INSERT ON flickr.photo_sizes FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER flickr_photo_sizes_updated_at_trigger
  BEFORE UPDATE ON flickr.photo_sizes FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
