-- Deploy create-photos-table

BEGIN;

CREATE TABLE "photos" (
  "id" SERIAL PRIMARY KEY,
  "spot-id" INTEGER REFERENCES spots(id) ON DELETE CASCADE,
  "user-id" INTEGER REFERENCES users(id) ON DELETE SET NULL,
  "flickr-id" BIGINT UNIQUE,
  "title" TEXT,
  "location" GEOMETRY(POINT, 4326),
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "photos-location-index" ON "photos" USING gist("location");
CREATE INDEX "photos-spot-id-index" ON "photos" ("spot-id");
CREATE INDEX "photos-title-fulltext-index" ON "photos" USING gin(to_tsvector('english', "title"));

CREATE TRIGGER "photos-created-at-trigger"
  BEFORE INSERT ON "photos" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "photos-updated-at-trigger"
  BEFORE UPDATE ON "photos" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
