(defproject burningswell/db "0.3.52"
  :description "The Burning Swell database library"
  :url "https://gitlab.com/burningswell/db"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :min-lein-version "2.0.0"
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[burningswell/core "0.0.81"]
                 [burningswell/config "0.1.57"]
                 [datumbazo "0.13.25"]
                 [funcool/clojure.jdbc "0.9.0"]
                 [medley "1.1.0"]
                 [net.postgis/postgis-jdbc "2.3.0"
                  :exclusions [postgresql org.postgresql/postgresql]]
                 [org.clojure/clojure "1.10.0"]
                 [org.postgresql/postgresql "42.2.5"]]
  :plugins [[lein-environ "1.1.0"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["eastwood"]]
            "test-ancient" ["test"]}
  :eastwood {:config-files ["test-resources/eastwood.clj"]
             :exclude-linters [:implicit-dependencies]}
  :filespecs [{:type :path :path "sqitch.conf"}]
  :main ^{:skip-aot true} burningswell.db.main
  :profiles {:dev {:dependencies [[ch.qos.logback/logback-classic "1.2.3"]
                                  [reloaded.repl "0.2.4"]]
                   :plugins [[jonase/eastwood "0.3.4"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]
                   :repl-options {:init-ns user}
                   :source-paths ["dev" "src"]}
             :uberjar {:aot :all
                       :main burningswell.db.main}}
  :uberjar-name "burningswell-db.jar")
