(ns burningswell.db.flickr.photos
  (:require [datumbazo.table :as t]))

(t/deftable photos
  "The Flickr photos table."
  (t/table :flickr.photos)
  (t/column :created-at :timestamp :not-null? true)
  (t/column :farm :integer :not-null? true)
  (t/column :id :text :primary-key? true)
  (t/column :isfamily :integer :not-null? true)
  (t/column :isfriend :integer :not-null? true)
  (t/column :ispublic :integer :not-null? true)
  (t/column :owner :text :not-null? true :references :flickr.users.id)
  (t/column :photo-id :integer :references :photos.id)
  (t/column :secret :text :not-null? true)
  (t/column :server :text :not-null? true)
  (t/column :title :text :not-null? true)
  (t/column :updated-at :timestamp :not-null? true)
  (t/column :url :text :not-null? true))
