(ns burningswell.db.google.users
  (:require [clojure.spec.alpha :as s]
            [datumbazo.core :as sql]
            [datumbazo.io :refer [citext]]
            [datumbazo.table :as t]))

(t/deftable users
  "The google users table."
  (t/table :google.users)
  (t/column :created-at :timestamp :not-null? true)
  (t/column :id :text :primary-key? true)
  (t/column :profile :jsonb)
  (t/column :updated-at :timestamp :not-null? true)
  (t/column :user-id  :integer :not-null? true :references :users/id))
