(ns burningswell.db.page-views
  (:require [inflections.core :as infl]
            [sqlingvo.core :as sql]))

(defn- sort-by-ids [ordered-ids column group-fn results]
  (let [groups (group-by column results)]
    (map #(group-fn %) (map groups ordered-ids))))

(defn- entity-table [table]
  (keyword (str "page-views." (name table))))

(defn- entity-viewer-table [table]
  (keyword (str "page-views." (name table) "_by_viewer")))

(defn- by-entity [db table foreign-key entity]
  (first @(sql/select db [:*]
            (sql/from (entity-table table))
            (sql/where `(= ~foreign-key ~(:id entity))))))

(defn- by-entities [db table foreign-key entities]
  (->> @(sql/select db [:*]
          (sql/from (entity-table table))
          (sql/where `(in ~foreign-key ~(map :id entities))))
       (sort-by-ids (map :id entities) foreign-key first)))

(defn- by-entities-by-viewer [db table foreign-key entities viewer]
  (->> @(sql/select db [:*]
          (sql/from (entity-viewer-table table))
          (sql/where `(and (= :viewer-id ~(:id viewer))
                           (in ~foreign-key ~(map :id entities)))))
       (sort-by-ids (map :id entities) foreign-key first)))

(defn- foreign-key
  [table]
  (keyword (str (infl/singular (name table)) "-id")))

(defn totals-by-id
  "Returns the total page views in `table` for `entity`."
  [db table entity & [viewer-id]]
  (by-entity db table (foreign-key table) entity))

(defn totals
  "Returns the total page views in `table` for `coll`."
  [db table coll & [viewer]]
  (let [foreign-key (foreign-key table)]
    (if (:id viewer)
      (by-entities-by-viewer db table foreign-key coll viewer)
      (by-entities db table foreign-key coll))))
